{****************************************************************************}
{ This unit allows for an easy interface with the imagine.dll                }
{****************************************************************************}

unit Image;


interface


uses
  WinTypes, WinProcs, SysUtils;

type
  TFPintCB = Procedure( i: Integer );
  function ConvertImage(aCallback: TFPintCB; nDither: Integer;
    sIn, sOut: String): Integer;
  function ReturnError(Err: Integer): String;
  function ConvertToBMP(aCallback: TFPintCB; nDither: Integer;
    FileIn, FileOut: PChar): Integer;


implementation


function ConvertToBMP; external 'IMAGINE' index 1;


{****************************************************************************}
function ConvertImage(aCallback: TFPintCB; nDither: Integer;
  sIn, sOut: String): Integer;
{****************************************************************************}
var
  FileIn: array[0..144] of Char;
  FileOut: array[0..144] of Char;
  iDither: Integer;
begin
  StrPCopy(FileIn, sIn);
  StrPCopy(FileOut, sOut);
  Result := ConvertToBMP(aCallback, nDither, FileIn, FileOut);
end;


{****************************************************************************}
function ReturnError(Err: Integer): String;
{****************************************************************************}
var
  ErrString: String;
begin
  case Err of
    1:  Result := 'Unsupported file feature.';
    2:  Result := 'Input file read error.';
    3:  Result := 'Insufficient memory.';
    4:  Result := 'Bad palette.';
    5:  Result := 'Color reduction error.';
    6:  Result := 'Invalid file structure.';
    7:  Result := 'Output file write error - out of disk space?';
    8:  Result := 'Temporary file error - out of disk space?';
    9:  Result := 'Could not open input file.';
    10: Result := 'Could not create output file.';
    11: Result := 'Can''t dither bitmap.';
  else
    Result := 'Unknown processing error';
  end;
end;


end.
